using System;
using System.Windows.Forms;
using System.ServiceModel;

namespace ServiceModelEx
{
   partial class AddressViewControl : NodeViewControl
   {
      public AddressViewControl()
      {
         InitializeComponent();
      }
      public void Refresh(EndpointAddress address)
      {
         if(address.Identity != null)
         {
            m_IdentityLabel.Text = "Tosamo: " + address.Identity.ToString();
         }
         else
         {
            m_IdentityLabel.Text = "Tosamo: brak";
         }

         if(address.IsNone)
         {
            m_IsNoneLabel.Text = "Brak: tak";
         }
         else
         {
            m_IsNoneLabel.Text = "Brak: tak";
         }
         if(address.IsAnonymous)
         {
            m_IsAnonymousLabel.Text = "Anonimowy: tak";
         }
         else
         {
            m_IsAnonymousLabel.Text = "Anonimowy: nie";
         }
         m_LocalPathTextBox.Text = address.Uri.AbsolutePath;
         m_AbsoluteURITextBox.Text = address.Uri.AbsoluteUri;
         m_AuthorityLabel.Text = "Domena: " + address.Uri.Authority;
         m_DnsSafeHostLabel.Text = "Bezpieczny host DNS: " +address.Uri.DnsSafeHost;
         m_HostLabel.Text = "Host: " + address.Uri.Host;
         m_HostNameTypeLabel.Text = "Typ nazwy hosta:" + address.Uri.HostNameType.ToString();
         if(address.Uri.IsAbsoluteUri)
         {
            m_IsAbsoluteUriLabel.Text = "Bezwzgldny URI: tak";
         }
         else
         {
            m_IsAbsoluteUriLabel.Text = "Bezwzgldny URI: nie";
         }
         if(address.Uri.IsLoopback)
         {
            m_IsLoopbackLabel.Text = "Ptla zwrotna: tak";
         }
         else
         {
            m_IsLoopbackLabel.Text = "Ptla zwrotna: nie";
         }
         m_LocalPathTextBox.Text = address.Uri.LocalPath;
         m_PortLabel.Text = "Port: " + address.Uri.Port.ToString();
         m_SchemaLabel.Text = "Schemat: " + address.Uri.Scheme;
      }
   }
}
